<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/default.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/budgets.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/zero_states.css" media="all" charset="utf-8" type="text/css" />

		<script type="text/javascript" src="../js/jquery.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/allAccounts.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>

		<script type="text/javascript">
$(AllAccountsInit);
$(CurrencyMenuInit);
		</script>
	</head>
	

			<!-- Do we have any data? -->
			<xsl:choose>
				<xsl:when test="count(accountGenre)>0">
					<body id="accountsSummary" class="">
						<div id="outerWrapper">
							<!-- Begin: innerWrapper - WITH data -->
							<div id="innerWrapperAllAccountsReport" class="fullWidth clearAfter">
								<!--<select id="currencyTypeSelect">
									<option value="">Options</option>
									<option value="">Euro</option>
									<option value="">Yen</option>
									<option value="">Peso</option>
								</select> -->
								<xsl:apply-templates select="currencies"/>
								<xsl:apply-templates select="netWorth"/>
								<xsl:apply-templates select="accountGenre"/>
								<div class="netWorth">
									Net Worth:&#x00A0;<strong><xsl:value-of select="netWorth/@total"/></strong>
								</div>
							</div><!-- End: innerWrapper -->
						</div><!-- END outerWrapper -->
					</body>							
				</xsl:when>	

				<xsl:otherwise>
					<body id="accountsSummary">
						<div id="outerWrapper">
							<!-- Begin: innerWrapper - NO data -->
							<div id="innerWrapperAllAccountsReport_empty" class="fullWidth clearAfter">
                                <h1 id="pageTitle">Accounts Summary</h1>
								<div class="zeroState">
									<div class="noDataA">
										<p class="first">You haven't added any accounts.</p>
										<p class="second">Add your accounts to Quicken to see your account summary.</p>
									</div>	
								</div>
							</div><!-- End: innerWrapper -->
						</div><!-- END outerWrapper -->
					</body>							
				</xsl:otherwise>	
			</xsl:choose>


	</html>
</xsl:template>

<!-- Net Worth -->

<xsl:template match="netWorth">
	<xsl:variable name="AssetClassName">
		<xsl:choose>
			<xsl:when test="number(@assetsPercent)=0">emptyBar</xsl:when>
			<xsl:otherwise><xsl:value-of select="@assetsClass"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="DebtClassName">
		<xsl:choose>
			<xsl:when test="number(@debtsPercent)=0">emptyBar</xsl:when>
			<xsl:otherwise><xsl:value-of select="@debtsClass"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<div id="pageOverview" class="clearAfter">
		<h2>As of <xsl:value-of select="@date"/></h2>
		<div id="budgetOverviewGraphs">
			<div id="assetsGraph" class="hBarGraph">
				<h3>Assets:</h3>
				<div style="width:{@assetsPercent}%;" class="{$AssetClassName}"></div>
				<span><xsl:value-of select="@assetsTotal"/></span>
			</div>
			<div id="debtGraph" class="hBarGraph">
				<h3>Liabilities:</h3>
				<div style="width:{@debtsPercent}%;" class="{$DebtClassName}"></div>
				<span><xsl:value-of select="@debtsTotal"/></span>
			</div>
		</div>
		<div id="assetsDebts">
			<xsl:if test="count(asset)">
				<dl class="assetsList">
					<dt>Assets</dt>
					<xsl:apply-templates select="asset"/>
				</dl>
			</xsl:if>
			<xsl:if test="count(debt)">
				<dl class="debtsList">
					<dt>Liabilities</dt>
					<xsl:apply-templates select="debt"/>
				</dl>
			</xsl:if>
			<div class="netWorthTotal" id="netWorth">
				Net Worth
				<span id="netWorthTotal"><xsl:value-of select="@total"/></span>
			</div>
		</div>
	</div>
</xsl:template>


<!-- Currencies -->

<xsl:template match="currencies">
	<xsl:if test="count(currency) > 1">
        <div class="currencies_select_div">
            <select id="currencyTypeSelect">
                <xsl:apply-templates select="currency"/>
            </select>
            <div class="select_arrow_wrapper">
                <div class="arrow_up"></div>
                <div class="arrow_down"></div>
            </div>
        </div>
	</xsl:if>
</xsl:template>


<xsl:template match="currency">
	<xsl:choose>
		<xsl:when test="@selected='YES'">
			<option value="{@currencyID}" selected=""><xsl:value-of select="@title"/></option>
		</xsl:when>
		<xsl:otherwise>
			<option value="{@currencyID}"><xsl:value-of select="@title"/></option>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- Assets and Debts -->

<xsl:template match="asset|debt">
	<dd>
		<span id="amount_{@genre}"><xsl:value-of select="@amount"/></span>
		<xsl:value-of select="@genre"/>
	</dd>
</xsl:template>


<!-- Account Type -->

<xsl:template match="accountGenre">
   	<div class="accountBlock opened">
		<xsl:choose>
			<xsl:when test="total[@sign='negative']">
				<div class="genreTotal minus" id="total_{@title}"><xsl:value-of select="total"/></div>
			</xsl:when>
			<xsl:otherwise>
				<div class="genreTotal" id="total_{@title}"><xsl:value-of select="total"/></div>
			</xsl:otherwise>
		</xsl:choose>
		<h2 class="actuator" id="header_{@title}"><xsl:value-of select="@title"/></h2>
		<div class="collapsible">
			<xsl:apply-templates select="section"/>
		</div>
	</div>
</xsl:template>


<xsl:template match="section">
	<xsl:variable name="HasLastDownloadColumn">
		<xsl:choose>
			<xsl:when test="count(account[@lastDownloadDate])>0">YES</xsl:when>
			<xsl:otherwise>NO</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="HasCreditLimitColumn">
		<xsl:choose>
			<xsl:when test="count(account[creditLimit])>0">YES</xsl:when>
			<xsl:otherwise>NO</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<img src="../images/icons/{@iconName}.png" width="34" height="32" alt="" />
	<table class="accountSummary" cellpadding="0" cellspacing="0" border="0">
		<thead>
			<tr>
				<th class="acctNameCol"><xsl:value-of select="@title"/></th>
				<xsl:if test="$HasCreditLimitColumn='YES'">
					<th class="creditLimitCol">Credit Limit</th>
				</xsl:if>
				<th class="lastUpCol">
					<xsl:if test="$HasLastDownloadColumn='YES'">Last Update</xsl:if>
				</th>
				<th class="balCol">Balance</th>
			</tr>
		</thead>
		<tbody>
			<xsl:apply-templates select="account">
				<xsl:with-param name="HasCreditLimitColumn" select="$HasCreditLimitColumn"/>
			</xsl:apply-templates>
			<xsl:if test="count(account)>=1">
				<tr>
					<td class="acctNameCol"></td>
					<xsl:if test="$HasCreditLimitColumn='YES'">
						<td class="creditLimitCol"></td>
					</xsl:if>
					<td class="lastUpCol"></td>
					<xsl:choose>
						<xsl:when test="count(account)>1 and total[@sign='negative']">
							<td class="totalCol minus" id="totalCol_{../@title}"><xsl:value-of select="total"/></td>
						</xsl:when>
						<xsl:otherwise>
							<td class="totalCol" id="totalCol_{../@title}"><xsl:value-of select="total"/></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:if>
		</tbody>
	</table>
</xsl:template>


<xsl:template match="account">
	<xsl:param name="HasCreditLimitColumn"/>
	
	<xsl:variable name="RowClass">
		<xsl:if test="@hasWarning">warning</xsl:if>
	</xsl:variable>

	<tr class="{$RowClass}">
		<td class="acctNameCol" id="accountName_{@name}"><xsl:value-of select="@name"/></td>
		<xsl:if test="$HasCreditLimitColumn='YES'">
			<td class="creditLimitCol" id="creditLimit_{@name}"><xsl:value-of select="creditLimit"/></td>
		</xsl:if>
		<td class="lastUpCol"><xsl:value-of select="@lastDownloadDate"/></td>

		<xsl:choose>
			<xsl:when test="balance[@sign='negative']">
				<td class="balCol minus" id="balance_{@name}"><xsl:value-of select="balance"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td class="balCol" id="balance_{@name}"><xsl:value-of select="balance"/></td>
			</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>


<xsl:template match="dateSort" />

</xsl:stylesheet>
